/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2022, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of maveod.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef NYMEADSERVICE_H
#define NYMEADSERVICE_H

#include <QObject>
#include <QDBusInterface>
#include <QDBusConnection>
#include <QDBusServiceWatcher>

#include "pushbuttonagent.h"

class NymeadService : public QObject
{
    Q_OBJECT
public:
    explicit NymeadService(QObject *parent = nullptr);

    bool available() const;

    void enableBluetooth(bool enable);
    void pushButtonPressed();

private:
    QDBusServiceWatcher *m_serviceWatcher = nullptr;

    PushButtonAgent *m_pushButtonAgent = nullptr;
    QDBusInterface *m_nymeadHardwareInterface = nullptr;
    QDBusInterface *m_nymeadHardwareBluetoothInterface = nullptr;

    bool m_available = false;
    uint m_initRetry = 0;
    uint m_initRetryLimit = 3;

    void setAvailable(bool available);

    bool init();

signals:
    void availableChanged(bool available);

private slots:
    void serviceRegistered(const QString &serviceName);
    void serviceUnregistered(const QString &serviceName);

    void initializeServices();
};

#endif // NYMEADSERVICE_H
