/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2020, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of maveod.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef PUSHBUTTONAGENT_H
#define PUSHBUTTONAGENT_H

#include <QObject>
#include <QDBusConnection>

class PushButtonAgent : public QObject
{
    Q_OBJECT
public:
    explicit PushButtonAgent(QObject *parent = nullptr);

    bool init(QDBusConnection::BusType busType = QDBusConnection::SystemBus);
    bool initialized() const;

signals:
    Q_SCRIPTABLE void PushButtonPressed();

public slots:
    void sendButtonPressed();

private:
    bool m_initialized = false;

};

#endif // PUSHBUTTONAGENT_H
