/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2024, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* GNU Lesser General Public License Usage
* Alternatively, this project may be redistributed and/or modified under the
* terms of the GNU Lesser General Public License as published by the Free
* Software Foundation; version 3. This project is distributed in the hope that
* it will be useful, but WITHOUT ANY WARRANTY; without even the implied
* warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this project. If not, see <https://www.gnu.org/licenses/>.
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "chargingsessionsconfiguration.h"
#include "qlist.h"

ChargingSessionsConfiguration::ChargingSessionsConfiguration()
{

}

QString ChargingSessionsConfiguration::reporterName() const
{
    return m_reporterName;
}

void ChargingSessionsConfiguration::setReporterName(const QString &reporterName)
{
    m_reporterName = reporterName;
}

QString ChargingSessionsConfiguration::reporterEmail() const
{
    return m_reporterEmail;
}

void ChargingSessionsConfiguration::setReporterEmail(const QString &reporterEmail)
{
    m_reporterEmail = reporterEmail;
}

QStringList ChargingSessionsConfiguration::recipientEmails() const
{
    return m_recipientEmails;
}

void ChargingSessionsConfiguration::setRecipientEmails(const QStringList &recipientEmails)
{
    m_recipientEmails = recipientEmails;
}

bool ChargingSessionsConfiguration::isValid() const
{
    return !m_reporterName.isEmpty() &&
           !m_reporterEmail.isEmpty() &&
           !m_recipientEmails.isEmpty();
}

bool ChargingSessionsConfiguration::operator==(const ChargingSessionsConfiguration &other) const
{
    return m_reporterName == other.reporterName() &&
           m_reporterEmail == other.reporterEmail() &&
           m_recipientEmails== other.recipientEmails();
}

bool ChargingSessionsConfiguration::operator!=(const ChargingSessionsConfiguration &other) const
{
    return !(*this == other);
}

QDebug operator<<(QDebug debug, const ChargingSessionsConfiguration &configuration)
{
    const QDebugStateSaver saver(debug);
    debug.nospace() << "CharingSessionConfiguration(";
    debug.nospace() << "Reporter: " << configuration.reporterName() << " <" << configuration.reporterEmail() << ">, ";
    debug.nospace() << configuration.recipientEmails() << ")";
    return debug;
}
