// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-chargingsessions.
*
* nymea-energy-plugin-chargingsessions is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-chargingsessions is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-chargingsessions. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "energysettings.h"
#include <nymeasettings.h>

#include <QLoggingCategory>
Q_DECLARE_LOGGING_CATEGORY(dcChargingSessions)

EnergySettings::EnergySettings(QObject *parent)
    : QSettings(NymeaSettings::settingsPath() + "/energy.conf", QSettings::IniFormat, parent)
{

}

ThingId EnergySettings::getAssociatedCarId(const ThingId &evChargerId)
{
    // FIXME: this is not a very elegant way to get the information about the associated car thing id.
    // A better solution would be a direct API between this energy plugin and the nymea-energy-plugin-nymea,
    // but for now this should do the job. The entire implementation works also without the energy plugin,
    // therefore this is optional either way.

    ThingId associatedCarId;

    beginGroup("ChargingInfos");
    foreach (const QString &evChargerIdString, childGroups()) {
        ThingId id = ThingId::fromString(evChargerIdString);
        if (id == evChargerId) {
            beginGroup(evChargerIdString);
            associatedCarId = ThingId(value("assignedCarId").toUuid());
            endGroup(); // evChargerIdString
            break;
        }
    }
    endGroup(); // ChargingInfos

    return associatedCarId;
}
