// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-chargingsessions.
*
* nymea-energy-plugin-chargingsessions is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-chargingsessions is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-chargingsessions. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef CHARGINGSESSIONSCONFIGURATION_H
#define CHARGINGSESSIONSCONFIGURATION_H

#include <QMetaObject>
#include <QStringList>
#include <QDebug>

class ChargingSessionsConfiguration
{
    Q_GADGET
    Q_PROPERTY(QString reporterName READ reporterName WRITE setReporterName FINAL)
    Q_PROPERTY(QString reporterEmail READ reporterEmail WRITE setReporterEmail FINAL)
    Q_PROPERTY(QStringList recipientEmails READ recipientEmails WRITE setRecipientEmails FINAL)

public:
    ChargingSessionsConfiguration();

    QString reporterName() const;
    void setReporterName(const QString &reporterName);

    QString reporterEmail() const;
    void setReporterEmail(const QString &reporterEmail);

    QStringList recipientEmails() const;
    void setRecipientEmails(const QStringList &recipientEmails);

    bool isValid() const;

    bool operator==(const ChargingSessionsConfiguration &other) const;
    bool operator!=(const ChargingSessionsConfiguration &other) const;

private:
    QString m_reporterName;
    QString m_reporterEmail;
    QStringList m_recipientEmails;

};

QDebug operator<<(QDebug debug, const ChargingSessionsConfiguration &configuration);


#endif // CHARGINGSESSIONSCONFIGURATION_H
