// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-chargingsessions.
*
* nymea-energy-plugin-chargingsessions is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-chargingsessions is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-chargingsessions. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef CHARGINGSESSIONSJSONHANDLER_H
#define CHARGINGSESSIONSJSONHANDLER_H

#include <QObject>

#include <jsonrpc/jsonhandler.h>

#include "chargingsessionsmanager.h"

class ChargingSessionsJsonHandler : public JsonHandler
{
    Q_OBJECT
public:
    explicit ChargingSessionsJsonHandler(ChargingSessionsManager *sessionManager, QObject *parent = nullptr);

    QString name() const override;

    Q_INVOKABLE JsonReply *SendReport(const QVariantMap &params);
    Q_INVOKABLE JsonReply *GetConfiguration(const QVariantMap &params);
    Q_INVOKABLE JsonReply *SetConfiguration(const QVariantMap &params);

signals:
    void ConfigurationChanged(const QVariantMap &params);

private:
    ChargingSessionsManager *m_sessionManager = nullptr;
};

#endif // CHARGINGSESSIONSJSONHANDLER_H
