// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-chargingsessions.
*
* nymea-energy-plugin-chargingsessions is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-chargingsessions is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-chargingsessions. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "chargingsessionsconfiguration.h"
#include "qlist.h"

ChargingSessionsConfiguration::ChargingSessionsConfiguration()
{

}

QString ChargingSessionsConfiguration::reporterName() const
{
    return m_reporterName;
}

void ChargingSessionsConfiguration::setReporterName(const QString &reporterName)
{
    m_reporterName = reporterName;
}

QString ChargingSessionsConfiguration::reporterEmail() const
{
    return m_reporterEmail;
}

void ChargingSessionsConfiguration::setReporterEmail(const QString &reporterEmail)
{
    m_reporterEmail = reporterEmail;
}

QStringList ChargingSessionsConfiguration::recipientEmails() const
{
    return m_recipientEmails;
}

void ChargingSessionsConfiguration::setRecipientEmails(const QStringList &recipientEmails)
{
    m_recipientEmails = recipientEmails;
}

bool ChargingSessionsConfiguration::isValid() const
{
    return !m_reporterName.isEmpty() &&
           !m_reporterEmail.isEmpty() &&
           !m_recipientEmails.isEmpty();
}

bool ChargingSessionsConfiguration::operator==(const ChargingSessionsConfiguration &other) const
{
    return m_reporterName == other.reporterName() &&
           m_reporterEmail == other.reporterEmail() &&
           m_recipientEmails== other.recipientEmails();
}

bool ChargingSessionsConfiguration::operator!=(const ChargingSessionsConfiguration &other) const
{
    return !(*this == other);
}

QDebug operator<<(QDebug debug, const ChargingSessionsConfiguration &configuration)
{
    const QDebugStateSaver saver(debug);
    debug.nospace() << "CharingSessionConfiguration(";
    debug.nospace() << "Reporter: " << configuration.reporterName() << " <" << configuration.reporterEmail() << ">, ";
    debug.nospace() << configuration.recipientEmails() << ")";
    return debug;
}
