# nymea-energy-plugin-chargingsessions


This energy plugin can be loaded by the [nymea-experience-plugin-energy](https://github.com/nymea/nymea-experience-plugin-energy) as an energy plugin and is responsible for managing individual charging sessions and provide an easy way to export and manage charging sessions over time. 

In order to load this plugin form a build dir you can add the build dir path to the `NYMEA_ENERGY_PLUGINS_EXTRA_PATH` environment variable. The energy experience will look into the paths specified in this environment variable for energy plugins.

## Building

In order to build this project, the `libnymea-dev` and the `libnymea-energy-dev` packages are required next to the default build dependencies for nymea.

## Debugging

The default logging category for this energy plugin is `ChargingSessions` and can be enabled either by using the `nymead.conf` file by adding following section: 

```
[LoggingRules]
ChargingSessions.debug=true
ChargingSessions.info=true
ChargingSessions.warning=true
```

or by starting the `nymead` using the paramter `-d ChargingSessions`.

# DBus interface

Example on how to fetch all charging sessions

    dbus-send --system --print-reply --dest=io.nymea.energy.chargingsessions /io/nymea/energy/chargingsessions io.nymea.energy.chargingsessions.GetSessions \
              array:string: int64:0 int64:0

Example on how to fetch for specif cars

    dbus-send --system --print-reply --dest=io.nymea.energy.chargingsessions /io/nymea/energy/chargingsessions io.nymea.energy.chargingsessions.GetSessions \
              array:string:"9e4c1d0b-1234-5678-90ab-ffeeddccbbaa","1c2d3e4f-aaaa-bbbb-cccc-ddddeeeeffff" int64:0 int64:0

Example on how to fetch sessions overlapping a timerange (timestamps are seconds since epoch, use `0` to omit a bound)

    dbus-send --system --print-reply --dest=io.nymea.energy.chargingsessions /io/nymea/energy/chargingsessions io.nymea.energy.chargingsessions.GetSessions \
              array:string:"9e4c1d0b-1234-5678-90ab-ffeeddccbbaa" int64:1700000000 int64:1700086400

## License

nymea-energy-plugin-chargingsessions is licensed under the terms of the GNU General Public License version 3 or (at your option) any later version. SPDX headers have been added to every source file to make the licensing explicit. See the included `COPYING` information available from <https://www.gnu.org/licenses/> for the full text. Copyright (C) 2013 - 2024, nymea GmbH and Copyright (C) 2024 - 2025, chargebyte austria GmbH.


# Benchmark tests

Following tests have been made on the PCE gateway (STM32 ARMv7 Processor rev 5 (v7l)) CPU, eMMC storage and 512 Mb ram.

| **Sesson count** | **Fetch DB [ms]** | **Write CSV [ms]** | **CSV file size [B]** | **Total duration [ms]** |
|-----------------:|------------------:|-------------------:|----------------------:|------------------------:|
| 100              | 42                | 105                | 9995                  | 1171                    |
| 200              | 64                | 211                | 20396                 | 1427                    |
| 300              | 91                | 589                | 30593                 | 1114                    |
| 400              | 159               | 785                | 40790                 | 1968                    |
| 500              | 139               | 803                | 50987                 | 1377                    |
| 1000             | 258               | 2168               | 102384                | 3690                    |
