# Repository Guidelines

## Project Structure & Modules
- Core plugin code lives in `energyplugin/` (manager, JSON handler, DB access, mail client, settings, translations). Entry point is `energypluginchargingsessions.*`.
- Packaging specs live in `debian*/`, while `build/` is an out-of-tree build scratchpad. Avoid editing generated files there.
- Tests sit in `tests/auto/` with Qt Test suites for charging sessions and the database; `tests/scripts/` holds helpers.

## Build, Test, and Development Commands
- Install deps: `libnymea-dev`, `libnymea-energy-dev`, Qt5/Qt6 build essentials.
- Build (release example):  
  ```bash
  mkdir -p build && cd build
  qmake ../nymea-energy-plugin-chargingsessions.pro CONFIG+=release
  make -j$(nproc)
  ```
- Run the plugin from the build dir by pointing nymea experience to it:  
  `NYMEA_ENERGY_PLUGINS_EXTRA_PATH=$(pwd) nymead ...`
- Update translations when needed: `cd energyplugin && qmake && make lupdate lrelease`.

## Coding Style & Naming Conventions
- C++ with Qt; Qt6 uses C++17, Qt5 uses C++11 (configured in `build.pri`). Use 4-space indents, braces on new lines (Qt style), CamelCase types, lowerCamelCase methods/variables, and ALL_CAPS macros.
- Prefer `QLoggingCategory` (`dcChargingSessions`, `dcTests`) for diagnostics; keep user-facing strings translatable.
- Header guards are via `#pragma once` or conventional include guards; follow existing pattern when adding files.

## Testing Guidelines
- Framework: Qt Test. Build and run from a clean dir:  
  ```bash
  mkdir -p build-tests && cd build-tests
  qmake ../tests/tests.pro
  make check   # runs the auto test binaries
  ```
- Add new suites under `tests/auto/<component>/`; name files `test<component>.{h,cpp}` and keep test names descriptive (`testFetchSessions_validRange`).
- Aim to cover DB queries and JSON/API flows; include regression cases for schema changes and backward compatibility.

## Commit & Pull Request Guidelines
- Commit messages are short, imperative summaries (e.g., `Update to parse ChargingConfigurations`, `Jenkins release build 1.12.3`). Keep one logical change per commit.
- PRs should outline the change, risks, and how to verify (commands/logs). Link related issues; include screenshots or sample JSON when affecting responses or exports.
- Before opening a PR: run `make` and `make check` in fresh build dirs, ensure translations still compile if touched, and note any new env vars (e.g., `NYMEA_ENERGY_PLUGINS_EXTRA_PATH` usage).

## Architecture & Configuration Tips
- The plugin exposes charging session data through nymea’s energy plugin interface; `ChargingSessionsManager` orchestrates DB and JSON handlers. Keep backward compatibility with existing `ChargingInfos`/`ChargingConfigurations` payloads.
- Default logging category is `ChargingSessions`; enable it via `nymead -d ChargingSessions` during debugging.
