// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-chargingsessions.
*
* nymea-energy-plugin-chargingsessions is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-chargingsessions is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-chargingsessions. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef CHARGINGSESSIONSTESTBASE_H
#define CHARGINGSESSIONSTESTBASE_H

#include <QObject>
#include <QtTest>
#include <QTcpSocket>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QLoggingCategory>

#include <nymeatestbase.h>

#include <nymeacore.h>
#include <nymeasettings.h>
#include <servers/mocktcpserver.h>

#include <energymanager.h>

#include "../../../energyplugin/chargingsessionsmanager.h"

using namespace nymeaserver;

class ChargingSessionsTestBase : public NymeaTestBase
{
    Q_OBJECT
public:
    explicit ChargingSessionsTestBase(QObject *parent = nullptr);

    inline void verifyThingError(const QVariant &response, Thing::ThingError error = Thing::ThingErrorNoError) {
        verifyError(response, "thingError", enumValueName(error));
    }

protected slots:
    void initTestCase(const QString &loggingRules = QString(), bool checkExperienceLoaded = true, bool disableLogEngine = true);
    void cleanupTestCase();

    void init();
    void cleanup();

public:
    void removeDevices();
    QVariant removeDevice(const QUuid &thingId);

protected:
    QNetworkAccessManager *m_networkAccessManager = nullptr;

};

#endif // CHARGINGSESSIONSTESTBASE_H
