// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-chargingsessions.
*
* nymea-energy-plugin-chargingsessions is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-chargingsessions is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-chargingsessions. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "energypluginchargingsessions.h"
#include "chargingsessionsmanager.h"
#include "chargingsessionsjsonhandler.h"
#include "dbus/chargingsessionsdbusinterface.h"

#include <QLoggingCategory>
Q_DECLARE_LOGGING_CATEGORY(dcChargingSessions)

EnergyPluginChargingSessions::EnergyPluginChargingSessions(QObject *parent)
    : EnergyPlugin(parent)
{
    qCDebug(dcChargingSessions()) << "Loading charging sessions energy plugin";
}

void EnergyPluginChargingSessions::init()
{
    qCDebug(dcChargingSessions()) << "Initializing charging sessions energy plugin";

    ChargingSessionsManager *sessionsManager = new ChargingSessionsManager(energyManager(), thingManager(), this);
    new ChargingSessionsDBusInterface(sessionsManager, this);
    jsonRpcServer()->registerExperienceHandler(new ChargingSessionsJsonHandler(sessionsManager, this), 0, 1);

    qCDebug(dcChargingSessions()) << "Plugin initialized successfully";
}
