/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2024, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* GNU Lesser General Public License Usage
* Alternatively, this project may be redistributed and/or modified under the
* terms of the GNU Lesser General Public License as published by the Free
* Software Foundation; version 3. This project is distributed in the hope that
* it will be useful, but WITHOUT ANY WARRANTY; without even the implied
* warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this project. If not, see <https://www.gnu.org/licenses/>.
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef CHARGINGACTION_H
#define CHARGINGACTION_H

#include <QHash>
#include <QObject>
#include <QMetaObject>

class ChargingAction
{
    Q_GADGET
    Q_PROPERTY(bool chargingEnabled READ chargingEnabled WRITE setChargingEnabled)
    Q_PROPERTY(double maxChargingCurrent READ maxChargingCurrent WRITE setMaxChargingCurrent)
    Q_PROPERTY(uint desiredPhaseCount READ desiredPhaseCount WRITE setDesiredPhaseCount)
    Q_PROPERTY(ChargingAction::ChargingActionIssuer issuer READ issuer WRITE setIssuer NOTIFY issuerChanged)

public:
    enum ChargingActionIssuer {
        ChargingActionIssuerUnknown,
        ChargingActionIssuerSurplusCharging,
        ChargingActionIssuerSpotMarketCharging,
        ChargingActionIssuerTimeRequirement,
        ChargingActionIssuerOverloadProtection
    };
    Q_ENUM(ChargingActionIssuer)

    ChargingAction();
    ChargingAction(bool chargingEnabled, double maxChargingCurrent, uint desiredPhaseCount, ChargingActionIssuer issuer, bool force = false);

    bool chargingEnabled() const;
    void setChargingEnabled(bool chargingEnabled);

    double maxChargingCurrent() const;
    void setMaxChargingCurrent(double maxChargingCurrent);

    uint desiredPhaseCount() const;
    void setDesiredPhaseCount(uint desiredPhaseCount);

    ChargingActionIssuer issuer() const;
    void setIssuer(ChargingActionIssuer issuer);
    QString issuerString() const;

    bool force() const;
    void setForce(bool force);

    static QString issuerToString(ChargingActionIssuer issuer);

private:
    bool m_chargingEnabled = 0;
    double m_maxChargingCurrent = 0;
    uint m_desiredPhaseCount = 3;
    ChargingActionIssuer m_issuer = ChargingActionIssuerUnknown;
    bool m_force = false;

};

typedef QHash<ChargingAction::ChargingActionIssuer, ChargingAction> ChargingActions;
Q_DECLARE_METATYPE(ChargingActions)

#endif // CHARGINGACTION_H
