/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2022, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* GNU Lesser General Public License Usage
* Alternatively, this project may be redistributed and/or modified under the
* terms of the GNU Lesser General Public License as published by the Free
* Software Foundation; version 3. This project is distributed in the hope that
* it will be useful, but WITHOUT ANY WARRANTY; without even the implied
* warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this project. If not, see <https://www.gnu.org/licenses/>.
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef EVCHARGER_H
#define EVCHARGER_H

#include "integrations/thing.h"
#include "smartchargingmanager.h"

#include <hardware/electricity.h>

#include <QObject>

class ThingManager;
class ThingActionInfo;

class EvCharger : public QObject
{
    Q_OBJECT
public:
    explicit EvCharger(ThingManager *thingManager, Thing *parent = nullptr);

    ThingId id() const;
    Thing *thing() const;
    QString name() const;

    uint chargingEnabledLockDuration() const; // s
    void setChargingEnabledLockDuration(uint chargingEnabledLockDuration);
    bool chargingEnabledLocked(const QDateTime &currentDateTime) const;

    uint chargingCurrentLockDuration() const; // s
    void setChargingCurrentLockDuration(uint chargingCurrentLockDuration);
    bool chargingCurrentLocked(const QDateTime &currentDateTime) const;

    bool available() const;

    bool chargingEnabled() const;
    ThingActionInfo *setChargingEnabled(bool power, const QDateTime &currentDateTime, bool force = false);

    bool pluggedIn() const;
    bool charging() const;

    uint maxChargingCurrentMaxValue() const;
    uint maxChargingCurrentMinValue() const;
    uint maxChargingCurrent() const;
    ThingActionInfo *setMaxChargingCurrent(uint maxChargingCurrent, const QDateTime &currentDateTime, bool force = false);

    bool hasPowerMeter() const;
    double currentPower() const;

    uint phaseCount() const;
    Electricity::Phases phases() const;
    Electricity::Phases meteredPhases() const;

    bool canSetPhaseCount() const;
    ThingActionInfo *setDesiredPhaseCount(int desiredPhases);

private:
    ThingManager *m_thingManager = nullptr;
    Thing *m_thing = nullptr;

    uint m_chargingEnabledLockDuration = 300;
    uint m_chargingCurrentLockDuration = 10;

    QDateTime m_lastChargingEnabledAction;
    QDateTime m_lastChargingCurrentAction;
};

class EvChargers: public QList<EvCharger*>
{

};

#endif // EVCHARGER_H
