// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef ENERGYMANAGERCONFIGURATION_H
#define ENERGYMANAGERCONFIGURATION_H

#include <QObject>

class EnergyManagerConfiguration : public QObject
{
    Q_OBJECT
public:
    explicit EnergyManagerConfiguration(QObject *parent = nullptr);

    uint chargingEnabledLockDuration() const;
    uint chargingCurrentLockDuration() const;
    uint minimumScheduleDuration() const;
    double spotMarketChargePredictableEnergyPercentage() const;

private:
    bool loadConfiguration(const QString &filePath);

    uint m_chargingEnabledLockDuration = 300;
    uint m_chargingCurrentLockDuration = 10;
    uint m_minimumScheduleDuration = 15;
    double m_spotMarketChargePredictableEnergyPercentage = 0.5;
};

#endif // ENERGYMANAGERCONFIGURATION_H
