greaterThan(QT_MAJOR_VERSION, 5) {
    message("Building using Qt6 support")
    CONFIG *= c++17
    QMAKE_LFLAGS *= -std=c++17
    QMAKE_CXXFLAGS *= -std=c++17
} else {
    message("Building using Qt5 support")
    CONFIG *= c++11
    QMAKE_LFLAGS *= -std=c++11
    QMAKE_CXXFLAGS *= -std=c++11
    DEFINES += QT_DISABLE_DEPRECATED_UP_TO=0x050F00
}

coverage {
    message(Building with code coverage enabled)
    # --coverage option contains: -fprofile-arcs -ftest-coverage -lgcov
    QMAKE_CXXFLAGS *= --coverage
    QMAKE_LDFLAGS *= --coverage
    LIBS += -lgcov
}

HEADERS += \
    $$PWD/energymanagerconfiguration.h \
    $$PWD/energysettings.h \
    $$PWD/evcharger.h \
    $$PWD/nymeaenergyjsonhandler.h \
    $$PWD/rootmeter.h \
    $$PWD/smartchargingmanager.h \
    $$PWD/spotmarket/spotmarketdataprovider.h \
    $$PWD/spotmarket/spotmarketdataproviderawattar.h \
    $$PWD/spotmarket/spotmarketmanager.h \
    $$PWD/types/chargingaction.h \
    $$PWD/types/charginginfo.h \
    $$PWD/types/chargingprocessinfo.h  \
    $$PWD/types/chargingschedule.h \
    $$PWD/types/scoreentry.h \
    $$PWD/types/smartchargingstate.h \
    $$PWD/types/timeframe.h \

SOURCES += \
    $$PWD/energymanagerconfiguration.cpp \
    $$PWD/energysettings.cpp \
    $$PWD/evcharger.cpp \
    $$PWD/nymeaenergyjsonhandler.cpp \
    $$PWD/rootmeter.cpp \
    $$PWD/smartchargingmanager.cpp \
    $$PWD/spotmarket/spotmarketdataprovider.cpp \
    $$PWD/spotmarket/spotmarketdataproviderawattar.cpp \
    $$PWD/spotmarket/spotmarketmanager.cpp \
    $$PWD/types/chargingaction.cpp \
    $$PWD/types/charginginfo.cpp \
    $$PWD/types/chargingprocessinfo.cpp \
    $$PWD/types/chargingschedule.cpp \
    $$PWD/types/scoreentry.cpp \
    $$PWD/types/smartchargingstate.cpp \
    $$PWD/types/timeframe.cpp \
