// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "chargingaction.h"

ChargingAction::ChargingAction()
{

}

ChargingAction::ChargingAction(bool chargingEnabled, double maxChargingCurrent, uint desiredPhaseCount, ChargingActionIssuer issuer, bool force) :
    m_chargingEnabled{chargingEnabled},
    m_maxChargingCurrent{maxChargingCurrent},
    m_desiredPhaseCount{desiredPhaseCount},
    m_issuer{issuer},
    m_force{force}
{

}

bool ChargingAction::chargingEnabled() const
{
    return m_chargingEnabled;
}

void ChargingAction::setChargingEnabled(bool chargingEnabled)
{
    m_chargingEnabled = chargingEnabled;
}

double ChargingAction::maxChargingCurrent() const
{
    return m_maxChargingCurrent;
}

void ChargingAction::setMaxChargingCurrent(double maxChargingCurrent)
{
    m_maxChargingCurrent = maxChargingCurrent;
}

uint ChargingAction::desiredPhaseCount() const
{
    return m_desiredPhaseCount;
}

void ChargingAction::setDesiredPhaseCount(uint desiredPhaseCount)
{
    m_desiredPhaseCount = desiredPhaseCount;
}

ChargingAction::ChargingActionIssuer ChargingAction::issuer() const
{
    return m_issuer;
}

void ChargingAction::setIssuer(ChargingActionIssuer issuer)
{
    m_issuer = issuer;
}

QString ChargingAction::issuerString() const
{
    return ChargingAction::issuerToString(m_issuer);
}

bool ChargingAction::force() const
{
    return m_force;
}

void ChargingAction::setForce(bool force)
{
    m_force = force;
}

QString ChargingAction::issuerToString(ChargingActionIssuer issuer)
{
    QString issuerString;
    switch (issuer) {
    case ChargingActionIssuerUnknown:
        issuerString = "Unknown";
        break;
    case ChargingActionIssuerSurplusCharging:
        issuerString = "Surplus";
        break;
    case ChargingActionIssuerSpotMarketCharging:
        issuerString = "Spot market";
        break;
    case ChargingActionIssuerTimeRequirement:
        issuerString = "Time requirement";
        break;
    case ChargingActionIssuerOverloadProtection:
        issuerString = "Overload protection";
        break;
    }

    return issuerString;
}
