// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef INTEGRATIONPLUGINENERGYMOCKS_H
#define INTEGRATIONPLUGINENERGYMOCKS_H

#include "integrations/integrationplugin.h"
#include <QObject>

#include "extern-plugininfo.h"

class EnergyMockController;

class IntegrationPluginEnergyMocks: public IntegrationPlugin
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "io.nymea.IntegrationPlugin" FILE "integrationpluginenergymocks.json")
    Q_INTERFACES(IntegrationPlugin)
public:
    explicit IntegrationPluginEnergyMocks(QObject *parent = nullptr);

    void setupThing(ThingSetupInfo *info) override;
    void thingRemoved(Thing *thing) override;

    void executeAction(ThingActionInfo *info) override;

private:
    QHash<Thing*, EnergyMockController *> m_controllers;

    // Update the meter data of the charger based on the current max charging current, connected, power and plugged in state
    void updateChargerMeter(Thing *thing);

};

#endif // INTEGRATIONPLUGINENERGYMOCKS_H
