// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef CHARGINGPROCESSINFO_H
#define CHARGINGPROCESSINFO_H

#include <QObject>
#include <QDateTime>

#include <hardware/electricity.h>

#include "chargingschedule.h"

class ChargingProcessInfo
{
public:
    ChargingProcessInfo();

    // The actual phase count available for charing
    int effectivePhaseCount = 1;

    // Tha actual phases used for charging
    Electricity::Phases effectivePhases = Electricity::PhaseA;

    // The capacity of the car.
    double carCapacityInWh = 40000;

    double carCapacityInkWh = 40;

    // The total amount of energy the car can save (kWh)
    double carTotalEnergy = 40;

    // The assumed SOC of the car according to the power loaded so far in %
    int carBatteryLevel = 100;

    // The phase count configured for this car
    uint carPhaseCount = 1;

    // The energy actuall reaching the battery after losses as percentage factor
    double carChargingEnergyLossFactor = 0.9;

    // The percentage of energy loss while charging (%)
    uint carChargingEnergyLoss = 10;

    // Overall minimum charging current (car and charger combined)
    uint minimalChargingCurrent = 6;

    // The assumed SOC of the car according to the power loaded so far (%)
    int remainingPercentageToCharge = 0;

    // Remaining required hours to charge with maximal power available
    double remainingHoursToCharge = 0;

    // The maximum power on each phase of the charger
    double chargerPhaseLimitPower = 6 * 230;

    // The maximum power on each phase overall
    double phaseLimitPower = 0;

    // The amount of hours it would take to charge the car 100% with maxPossiblePhases
    double totalChargeHours = 0;

    // The voltage used for all the calculations
    double voltage = 230.0;

    // The date time when the car will reach the target percentage using max power
    QDateTime projectedEndTime;


    // Phase switching
    bool canSwitchPhaseCount = false;

    // Maximum possible phase count for charging
    uint maxPossiblePhaseCount = 1;

    // Minimal possible phase count for charging
    uint minPossiblePhaseCount = 1;

    // Tha actual phases used for charging
    Electricity::Phases maxPossiblePhases = Electricity::PhaseA;


    // The battery charged using spotmarket today so far
    double spotMarketEnergyChargedToday = 0;

    // How much energy will be required today from spotmarket kWh
    double spotMaketEnergyRequiredToday = 0;

    // The amount of battery percentage to charge from spotmarket today
    double spotMarketPercentageRequiredToday = 0;

    // True if we have to charge a certain amount of energy today,
    // either tought the charging info daily percentage or to meet
    // or to meet an endtime in the far unknwon future and charge some energy
    // in the meantime
    bool chargeFixedAmountSpotmarketToday = false;


    // This property is true if the spotmarket will be used to meet the target time.
    bool chargingUntilTargetTimeUsingSpotmarket = false;

    // The total energy charged using this charger (acumulate counter) kWh
    double lastTotalEnergyCharged = 0;

    ChargingSchedule currentSchedule;

    //    // Required energy left (Wh) to charge (assumed as best as we can)
    //    double requiredEnergy = 0;

    //    // Total min power (W) based on phase count n -> P = U * I(min charger/car) * n
    //    double minimalChargingPower = 0;

    //    // Total max power (W) possible based on phase count n -> P = U * I(max charger/car) * n
    //    double maximalChargingPower = 0;

    //    // Possible adjustable stepsize power (W) -> P = U * 1A * n
    //    // This describes the playground we have for this charger
    //    double powerStepSize = 0;

    //    // The amount of theoretical steps between min power and max power
    //    int powerStepTheoreticalMaxCount = 0;

    //    // Min current for min power
    //    uint minCurrent = 0;

    //    // Max current according to max power
    //    uint maxCurrent = 0;

    //    // Theoretical power (W) based on 230V and set charging current (this is what we expect) P = 230V * I(set) * n
    //    double currentPowerTheoretical = 0;

    //    // The actual current power measured on the charger.
    //    // If this is a charger without meter, we use the theoretical value here
    //    double currentPower = 0;

    //    // The absolute minimum surplus required to start charing. This depends on
    //    // the min charging power and the acquisition tolerance.
    //    double minimumSurplusForCharging = 0;

    //    // The last time an adjustment has been made
    //    QDateTime lastActionPerformed;

    //    // The datetime when the battery would be full if using min charging power
    //    QDateTime endTimeMinEnergy;

    //    // The datetime when the battery would be full if using max charging power
    //    QDateTime endTimeMaxEnergy;


};

#endif // CHARGINGPROCESSINFO_H
