// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef SPOTMARKETPROVIDERMOCK_H
#define SPOTMARKETPROVIDERMOCK_H

#include <QObject>

#include "../../../energyplugin/spotmarket/spotmarketdataprovider.h"

class SpotMarketDataProviderMock : public SpotMarketDataProvider
{
    Q_OBJECT
public:
    explicit SpotMarketDataProviderMock(QNetworkAccessManager *networkManager, QObject *parent = nullptr);
    ~SpotMarketDataProviderMock() override = default;

    QUuid providerId() const override;

    void setDataEntries(const ScoreEntries &scoreEntries);

    QDateTime currentDateTime() const;
    void setCurrentDataTime(const QDateTime &currentDateTime);

    bool prepareResourceData(const QString &resourceName, const QDateTime &startDateTime);
    void setAvailable(bool available);

public slots:
    void enable() override;
    void disable() override;
    void refreshData() override;

private:
    ScoreEntries m_preparedScoreEntries;
    QDateTime m_currentDateTime;
};

#endif // SPOTMARKETPROVIDERMOCK_H
