// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea. is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea. is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea.. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "experiencepluginenergy.h"

#include "energymanagerimpl.h"

#include "energyplugin.h"

#include <jsonrpc/jsonrpcserver.h>
#include <loggingcategories.h>

#include <QDir>
#include <QCoreApplication>
#include <QPluginLoader>

NYMEA_LOGGING_CATEGORY(dcEnergyExperience, "EnergyExperience")

ExperiencePluginEnergy::ExperiencePluginEnergy()
{

}

void ExperiencePluginEnergy::init()
{
    qCDebug(dcEnergyExperience()) << "Initializing mock energy experience";
    m_energyManager = new EnergyManagerImpl(thingManager(), this);

    SmartChargingManager *chargingManager = new SmartChargingManager(energyManager(), thingManager(), this);
    jsonRpcServer()->registerExperienceHandler(new NymeaEnergyJsonHandler(chargingManager, this), 0, 2);
}

void ExperiencePluginEnergy::testCall()
{
    qCDebug(dcEnergyExperience()) << "Test call!";
}
