// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef ROOTMETER_H
#define ROOTMETER_H

#include "smartchargingmanager.h"

#include <hardware/electricity.h>
#include <QObject>

class Thing;

class RootMeter : public QObject
{
    Q_OBJECT
public:
    explicit RootMeter(Thing *parent = nullptr);

    double currentPower() const;

    double currentPowerPhaseA() const;
    double currentPowerPhaseB() const;
    double currentPowerPhaseC() const;

    double currentPhaseA() const;
    double currentPhaseB() const;
    double currentPhaseC() const;

    double calculateAllowanceAmpere(Electricity::Phases phases, uint phasePowerLimit);

signals:
    void currentPowerChanged(double currentPower);

private:
    Thing *m_thing = nullptr;

};

#endif // ROOTMETER_H
