// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef SPOTMARKETDATAPROVIDERAWATTAR_H
#define SPOTMARKETDATAPROVIDERAWATTAR_H

#include <QTimer>
#include <QObject>

#include "spotmarketdataprovider.h"

class SpotMarketDataProviderAwattar : public SpotMarketDataProvider
{
    Q_OBJECT
public:
    enum AwattarCountry {
        AwattarCountryAustria,
        AwattarCountryGermany
    };
    Q_ENUM(AwattarCountry)

    explicit SpotMarketDataProviderAwattar(QNetworkAccessManager *networkManager, AwattarCountry country = AwattarCountryAustria, QObject *parent = nullptr);
    ~SpotMarketDataProviderAwattar() override = default;

    QUuid providerId() const override;

    QLocale::Country country() const;

public slots:
    void enable() override;
    void disable() override;
    void refreshData() override;

private:
    QTimer m_refreshTimer;
    QDateTime m_lastRefresh;
    QLocale::Country m_country = QLocale::Austria;

private slots:
    void onRefreshTimout();
    void evaluateAvailable();

};

#endif // SPOTMARKETDATAPROVIDERAWATTAR_H
