// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef ENERGYEXPERIENCEENERGYMOCK_H
#define ENERGYEXPERIENCEENERGYMOCK_H

#include <QObject>
#include <experiences/experienceplugin.h>

#include "energyplugin.h"

#include <QLoggingCategory>

Q_DECLARE_LOGGING_CATEGORY(dcEnergyExperience)

class EnergyManagerMock;
class SmartChargingManager;
class EnergyJsonHandler;
class NymeaEnergyJsonHandler;
class SpotMarketManager;

class ExperiencePluginEnergyMock: public ExperiencePlugin
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "io.nymea.ExperiencePlugin")
    Q_INTERFACES(ExperiencePlugin)

public:
    ExperiencePluginEnergyMock();
    void setEnergyLogDbFilePath(const QString &energyLogDbFilePath);

    void init() override;

    EnergyManagerMock *energyManager() const;
    SmartChargingManager *smartChargingManager() const;
    SpotMarketManager *spotMarketManager() const;

    void testCall();

private:
    QString m_energyLogDbFilePath;
    EnergyManagerMock *m_energyManager = nullptr;
    SmartChargingManager *m_smartChargingManager = nullptr;
    EnergyJsonHandler *m_energyJsonHandler = nullptr;
    NymeaEnergyJsonHandler *m_nymeaEnergyJsonHandler = nullptr;
    SpotMarketManager *m_spotMarketManager = nullptr;

};

#endif // ENERGYEXPERIENCEENERGYMOCK_H
