// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "energypluginnymea.h"
#include "smartchargingmanager.h"
#include "nymeaenergyjsonhandler.h"
#include "energymanagerconfiguration.h"
#include "spotmarket/spotmarketmanager.h"
#include "dbus/energymanagerdbusinterface.h"

#include "plugininfo.h"

EnergyPluginNymea::EnergyPluginNymea(QObject *parent) : EnergyPlugin(parent)
{
    qCDebug(dcNymeaEnergy()) << "Loading nymea.energy plugin";
}

void EnergyPluginNymea::init()
{
    qCDebug(dcNymeaEnergy()) << "Initializing nymea.energy plugin";

    EnergyManagerConfiguration *configuration = new EnergyManagerConfiguration(this);
    QNetworkAccessManager *networkManager = new QNetworkAccessManager(this);

    SpotMarketManager *spotMarketManager = new SpotMarketManager(networkManager, this);
    SmartChargingManager *chargingManager = new SmartChargingManager(energyManager(), thingManager(), spotMarketManager, configuration, this);

    new EnergyManagerDbusInterface(chargingManager, this);

    jsonRpcServer()->registerExperienceHandler(new NymeaEnergyJsonHandler(spotMarketManager, chargingManager, this), 0, 8);
}
