// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef NYMEAENERGYJSONHANDLER_H
#define NYMEAENERGYJSONHANDLER_H

#include <QObject>

#include <jsonrpc/jsonhandler.h>

#include "types/scoreentry.h"

class SmartChargingManager;
class SpotMarketManager;

class NymeaEnergyJsonHandler : public JsonHandler
{
    Q_OBJECT
public:
    explicit NymeaEnergyJsonHandler(SpotMarketManager *spotMarketManager, SmartChargingManager *smartChargingManager, QObject *parent = nullptr);

    QString name() const override;

    Q_INVOKABLE JsonReply *GetPhasePowerLimit(const QVariantMap &params);
    Q_INVOKABLE JsonReply *SetPhasePowerLimit(const QVariantMap &params);

    Q_INVOKABLE JsonReply *GetAcquisitionTolerance(const QVariantMap &params);
    Q_INVOKABLE JsonReply *SetAcquisitionTolerance(const QVariantMap &params);

    Q_INVOKABLE JsonReply *GetBatteryLevelConsideration(const QVariantMap &params);
    Q_INVOKABLE JsonReply *SetBatteryLevelConsideration(const QVariantMap &params);

    Q_INVOKABLE JsonReply *GetChargingInfos(const QVariantMap &params);
    Q_INVOKABLE JsonReply *SetChargingInfo(const QVariantMap &params, const JsonContext &context);

    Q_INVOKABLE JsonReply *GetLockOnUnplug(const QVariantMap &params);
    Q_INVOKABLE JsonReply *SetLockOnUnplug(const QVariantMap &params);

    Q_INVOKABLE JsonReply *GetAvailableSpotMarketProviders(const QVariantMap &params);
    Q_INVOKABLE JsonReply *GetSpotMarketConfiguration(const QVariantMap &params);
    Q_INVOKABLE JsonReply *SetSpotMarketConfiguration(const QVariantMap &params);
    Q_INVOKABLE JsonReply *GetSpotMarketScoreEntries(const QVariantMap &params);

    Q_INVOKABLE JsonReply *GetChargingSchedules(const QVariantMap &params);

signals:
    void PhasePowerLimitChanged(const QVariantMap &params);
    void AcquisitionToleranceChanged(const QVariantMap &params);
    void LockOnUnplugChanged(const QVariantMap &params);
    void ChargingInfoAdded(const QVariantMap &params);
    void ChargingInfoRemoved(const QVariantMap &params);
    void ChargingInfoChanged(const QVariantMap &params);
    void SpotMarketConfigurationChanged(const QVariantMap &params);
    void SpotMarketScoreEntriesChanged(const QVariantMap &params);
    void ChargingSchedulesChanged(const QVariantMap &params);
    void BatteryLevelConsiderationChanged(const QVariantMap &params);

private:
    SpotMarketManager *m_spotMarketManager;
    SmartChargingManager *m_smartChargingManager = nullptr;

    void sendSpotMarketConfigurationChangedNotification();

};

#endif // NYMEAENERGYJSONHANDLER_H
