// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef MOCKCONTROLLER_H
#define MOCKCONTROLLER_H

#include <typeutils.h>
#include <types/event.h>
#include <types/action.h>
#include <types/actiontype.h>

#include <QTcpServer>
#include <QDateTime>
#include <QUrlQuery>

class Thing;

class EnergyMockController : public QTcpServer
{
    Q_OBJECT
public:
    explicit EnergyMockController(Thing *thing, QObject *parent = nullptr);
    ~EnergyMockController();

    void incomingConnection(qintptr socket) override;

    void logActionExecuted(const ActionType &actionType, const Action &action);

signals:
    void generateEvent(const Event &event);
    void updateStateRequestReceived(const QUrlQuery &query);

private:
    QByteArray generateHeader();
    QByteArray generateJsonResponse(const QJsonDocument &document);
    QByteArray generateWebPage();

private slots:
    void onReadyRead();

private:
    Thing *m_thing = nullptr;
    QList<QPair<ActionTypeId, QDateTime> > m_actionList;
    QVariantList m_executedActions;
};

#endif // MOCKCONTROLLER_H
