// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <QSignalSpy>
#include <QtTest>

#include "../common/energytestbase.h"

class TestCharging: public EnergyTestBase
{
    Q_OBJECT
public:
    explicit TestCharging(QObject *parent = nullptr);

private slots:
    // Basic adding and removing mock things
    void testAddCharger();
    void testAddSimpleCharger();
    void testAddCar();
    void testAddMeter();

    // Basic api calls
    void getSetPhaseLimits();

    void getSetLockOnUnplug_data();
    void getSetLockOnUnplug();

    void getSetAcquisitionTolerance_data();
    void getSetAcquisitionTolerance();

    void getSetBatteryLevelConsideration_data();
    void getSetBatteryLevelConsideration();

    void addChargingInfo_data();
    void addChargingInfo();

    // Test individual logic
    void testEcoMode_data();
    void testEcoMode();

    void testEcoModePhaseSwitching_data();
    void testEcoModePhaseSwitching();

    void testBatteryLevelConsideration_data();
    void testBatteryLevelConsideration();

    void batteryLevelConsiderationStopCharging_data();
    void batteryLevelConsiderationStopCharging();

    void testOverloadProtectionManualMode_data();
    void testOverloadProtectionManualMode();

    void testOverloadProtectionEcoMode_data();
    void testOverloadProtectionEcoMode();

};
