// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "simulationtestpoint.h"

SimulationTestPoint::SimulationTestPoint(TestType testType, const QVariant &expectedValue)
    : m_testType{testType},
    m_expectedValue{expectedValue}
{

}

SimulationTestPoint::TestType SimulationTestPoint::testType() const
{
    return m_testType;
}

QVariant SimulationTestPoint::expectedValue() const
{
    return m_expectedValue;
}

QDebug operator<<(QDebug debug, const SimulationTestPoint &simulationTestPoint)
{
    const QDebugStateSaver saver(debug);
    debug.nospace() << "TestPoint(";

    switch (simulationTestPoint.testType()) {
    case SimulationTestPoint::TestTypeCharging:
        debug.nospace() << "Charging";
        break;
    case SimulationTestPoint::TestTypeMaxChargingCurrent:
        debug.nospace() << "Charging current";
        break;
    case SimulationTestPoint::TestTypeStateOfCharge:
        debug.nospace() << "SoC";
        break;
    }

    debug.nospace() << ", " << simulationTestPoint.expectedValue() << ")";
    return debug;
}
