# Repository Guidelines

This plugin extends the nymea energy experience with smart charging, spot market scheduling, and overload protection. Follow these notes to keep contributions consistent and easy to review.

## Project Structure & Module Organization
- `energyplugin/`: Core plugin sources; domain subfolders like `spotmarket/`, `types/`, and `translations/`.
- `tests/auto/`: Qt test suites (`charging`, `spotmarket`, `simulation`) plus shared mocks in `tests/mocks/`.
- `docker-simulation.sh`: Runs simulation plots in a container; outputs to `results/`.
- Packaging specs live in `debian*/`; coverage helper script sits at `generate-coverage-report.sh`.

## Build, Test, and Development Commands
```bash
mkdir -p build && cd build
qmake ../nymea-energy-plugin-nymea.pro CONFIG+=debug   # add CONFIG+=release for production or CONFIG+=coverage for lcov
make -j$(nproc)
```
- Run unit suites from the build tree: `tests/auto/charging/nymeaenrgytestcharging`, `tests/auto/spotmarket/nymeaenrgytestspotmarket`.
- Simulation test binary: `tests/auto/simulation/nymea-energy-simulation` (built with `ENERGY_SIMULATION` define).
- Coverage: after building with `CONFIG+=coverage` and running tests, generate HTML via `../generate-coverage-report.sh -b <build-dir>`.

## Coding Style & Naming Conventions
- C++/Qt style with 4-space indentation; braces on new lines for classes/functions, inline for control blocks.
- Classes/Qt types use `CamelCase`; methods, variables, and signals use `camelCase`; constants prefer `ALL_CAPS`.
- Keep existing logging macros (`qCDebug(dcNymeaEnergy())`) and guard macros (`ENERGY_SIMULATION`) intact.
- New files should retain the SPDX header `// SPDX-License-Identifier: GPL-3.0-or-later` and matching license block.

## Testing Guidelines
- Framework: Qt Test with `QTest` fixtures and custom `EnergyTestBase`. Use meaningful data rows (`QTest::newRow`) and spies where relevant.
- Name new tests after behavior (`testAddCharger`, `getSetPhaseLimits` pattern) and group by feature area under `tests/auto/<module>`.
- Ensure simulations still pass when modifying scheduling logic; prefer adding regression cases over widening tolerances.

## Commit & Pull Request Guidelines
- Use short, imperative commit subjects (`charging: tighten lock-on-unplug bounds`). Explain rationale and side effects in the body.
- PRs should include: summary of changes, affected areas (e.g., smart charging, spot market), test commands and results, and any configuration knobs touched.
- Link issues or tickets when available; attach screenshots or log snippets for simulation/coverage outputs if they support the review.

## Configuration & Safety Tips
- Local energy manager config is read-only and optional; set `NYMEA_ENERGY_MANAGER_CONFIG` to point to a JSON file (defaults to `/var/lib/nymea/energy-manager-configuration.json`). Use defaults unless you need a targeted test scenario.
- When tweaking scheduling or overload thresholds, document the new defaults and update simulations to reflect expected behavior.
