// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <QtTest>
#include <QDateTime>

#include "simulationbase.h"

using namespace nymeaserver;

class ChargerPlugEvent
{
public:
    ChargerPlugEvent() = default;
    ChargerPlugEvent(const QDateTime &dt, bool pi = false, int pu = 0)
        : dateTime{dt},
        pluggedIn{pi},
        percentageUsed{pu}
    {}
    QDateTime dateTime;
    bool pluggedIn;
    int percentageUsed = 0;
};

class Simulation: public SimulationBase
{
    Q_OBJECT
public:
    explicit Simulation(QObject *parent = nullptr) : SimulationBase(parent) { };

    typedef QList<ChargerPlugEvent> ChargerPlugEvents;
    typedef QList<int> DetailsStepList;

private slots:
    void run_data();
    void run();

    void printStates(Thing *thing);
    void updateChargerMeter(Thing *thing);

    QStringList plotOriginalData(int powerBalanceCount);
    QStringList plotSimulation(const QString &title, int powerBalanceCount);
    QStringList plotSpotMarketData(int powerBalanceCount);

};

Q_DECLARE_METATYPE(ChargerPlugEvent)
Q_DECLARE_METATYPE(Simulation::ChargerPlugEvents)
Q_DECLARE_METATYPE(Simulation::DetailsStepList)
