/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2020, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef STREAMUNLIMITEDREQUEST_H
#define STREAMUNLIMITEDREQUEST_H

#include <QObject>
#include <QHostAddress>
#include <QNetworkReply>

class NetworkAccessManager;

class StreamUnlimitedGetRequest : public QObject
{
    Q_OBJECT
public:
    explicit StreamUnlimitedGetRequest(NetworkAccessManager *nam, const QHostAddress &hostAddress, int port, const QString &path, const QStringList &roles, QObject *parent = nullptr);

signals:
    void error(QNetworkReply::NetworkError error);
    void finished(const QVariantMap &results);

};

class StreamUnlimitedSetRequest : public QObject
{
    Q_OBJECT
public:
    explicit StreamUnlimitedSetRequest(NetworkAccessManager *nam, const QHostAddress &hostAddress, int port, const QString &path, const QString &role, const QVariant &value, QObject *parent = nullptr, QNetworkAccessManager::Operation operation = QNetworkAccessManager::GetOperation);

signals:
    void error(QNetworkReply::NetworkError error);
    void finished(const QByteArray &data);

};

class StreamUnlimitedBrowseRequest : public QObject
{
    Q_OBJECT
public:
    explicit StreamUnlimitedBrowseRequest(NetworkAccessManager *nam, const QHostAddress &hostAddress, int port, const QString &path, const QStringList &roles, QObject *parent = nullptr);

signals:
    void error(QNetworkReply::NetworkError error);
    void finished(const QVariantMap &results);

private:
    void fetchBatch(NetworkAccessManager *nam, const QHostAddress &hostAddress, int port, const QString &path, const QStringList &roles, int from, int to);

    QVariantList m_rowCache;
};


#endif // STREAMUNLIMITEDREQUEST_H
