/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2020, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "integrationplugintrinod.h"
#include "plugininfo.h"
#include "co009.h"

#include <QDebug>

QHash<QString, QUuid> idMap = {
    {"thingClassId", connecteThingClassId},
    {"idParamTypeId", connecteThingIdParamTypeId},

    {"connectedStateTypeId", connecteConnectedStateTypeId},
    {"playbackStatusStateTypeId", connectePlaybackStatusStateTypeId},
    {"playDurationStateTypeId", connectePlayDurationStateTypeId},
    {"playTimeStateTypeId", connectePlayTimeStateTypeId},
    {"volumeStateTypeId", connecteVolumeStateTypeId},
    {"muteStateTypeId", connecteMuteStateTypeId},
    {"titleStateTypeId", connecteTitleStateTypeId},
    {"artistStateTypeId", connecteArtistStateTypeId},
    {"collectionStateTypeId", connecteCollectionStateTypeId},
    {"artworkStateTypeId", connecteArtworkStateTypeId},
    {"shuffleStateTypeId", connecteShuffleStateTypeId},
    {"repeatStateTypeId", connecteRepeatStateTypeId},
    {"powerStateTypeId", connectePowerStateTypeId},

    {"playActionTypeId", connectePlayActionTypeId},
    {"pauseActionTypeId", connectePauseActionTypeId},
    {"stopActionTypeId", connecteStopActionTypeId},
    {"skipNextActionTypeId", connecteSkipNextActionTypeId},
    {"skipBackActionTypeId", connecteSkipBackActionTypeId},
    {"increaseVolumeActionTypeId", connecteIncreaseVolumeActionTypeId},
    {"decreaseVolumeActionTypeId", connecteDecreaseVolumeActionTypeId},

//    {"addToPlayQueueBrowserItemActionTypeId", connecteAddToPlayQueueBrowserItemActionTypeId},
//    {"clearPlaylistBrowserItemActionTypeId", connecteClearPlaylistBrowserItemActionTypeId},
};

IntegrationPluginTrinod::IntegrationPluginTrinod():
    IntegrationPluginStreamUnlimited(idMap)
{
}

void IntegrationPluginTrinod::init()
{
    // FIXME: This will break in case 3nod releases another device with StreamSDK
    setupZeroConfBrowser("_sues800device._tcp", "Connecte");
}

void IntegrationPluginTrinod::setupThing(ThingSetupInfo *info)
{
    IntegrationPluginStreamUnlimited::setupThing(info);

    Thing *thing = info->thing();
    Co009* device = dynamic_cast<Co009*>(m_devices.value(info->thing()));

    connect(device, &Co009::inputSourceChanged, thing, [=](const QString &inputSource){
        thing->setStateValue(connecteInputSourceStateTypeId, inputSource);
    });
    connect(device, &Co009::favoriteChanged, thing, [=](bool isFavorite){
        thing->setStateValue(connecteLikeStateTypeId, isFavorite);
    });
}

void IntegrationPluginTrinod::executeAction(ThingActionInfo *info)
{
    Co009 *device = dynamic_cast<Co009*>(m_devices.value(info->thing()));

    QUuid commandId;
    if (info->action().actionTypeId() == connecteInputSourceActionTypeId) {
        commandId = device->setInputSource(info->action().paramValue(connecteInputSourceActionInputSourceParamTypeId).toString());
        if (commandId.isNull()) {
            info->finish(Thing::ThingErrorHardwareFailure, QT_TR_NOOP("Selecting this input source is not supported. Please select another input source, start streaming from an external device or select an item in the media browser."));
            return;
        }
    } else if (info->action().actionTypeId() == connecteLikeActionTypeId) {
        commandId = device->setFavorite(info->action().paramValue(connecteLikeActionLikeParamTypeId).toBool());
    }

    if (!commandId.isNull()) {
        connect(device, &StreamUnlimitedDevice::commandCompleted, info, [=](const QUuid &replyCommandId, bool success){
            if (replyCommandId == commandId) {
                info->finish(success ? Thing::ThingErrorNoError : Thing::ThingErrorHardwareFailure);
            }
        });
    } else {
        IntegrationPluginStreamUnlimited::executeAction(info);
    }
}

StreamUnlimitedDevice *IntegrationPluginTrinod::createStreamUnlimitedDevice()
{
    return new Co009(hardwareManager()->networkManager(), idMap, this);
}

