#ifndef ARTWORKCOLORPROVIDER_H
#define ARTWORKCOLORPROVIDER_H

#include <network/networkaccessmanager.h>

#include <QObject>
#include <QColor>

class ArtworkColorProvider : public QObject
{
    Q_OBJECT
public:
    explicit ArtworkColorProvider(NetworkAccessManager *nam, QObject *parent = nullptr);

    void setArtworkUrl(const QString &artworkUrl);

    QColor artworkColor() const;

signals:
    void artworkColorChanged(const QColor &color);

private:
    QColor calculateArtworkDominantColor(const QImage &image);

    QColor m_artworkColor = Qt::white;
    NetworkAccessManager *m_nam = nullptr;


};

#endif // ARTWORKCOLORPROVIDER_H
