/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2025, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* GNU Lesser General Public License Usage
* Alternatively, this project may be redistributed and/or modified under the
* terms of the GNU Lesser General Public License as published by the Free
* Software Foundation; version 3. This project is distributed in the hope that
* it will be useful, but WITHOUT ANY WARRANTY; without even the implied
* warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this project. If not, see <https://www.gnu.org/licenses/>.
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef SGREADYINTERFACE_H
#define SGREADYINTERFACE_H

#include <QObject>
#include <gpio.h>

class SgReadyInterface : public QObject
{
    Q_OBJECT
public:
    enum SgReadyMode {
        SgReadyModeOff,
        SgReadyModeLow,
        SgReadyModeStandard,
        SgReadyModeHigh
    };
    Q_ENUM(SgReadyMode)

    explicit SgReadyInterface(int gpioNumber1, int gpioNumber2, QObject *parent = nullptr);

    SgReadyMode sgReadyMode() const;
    bool setSgReadyMode(SgReadyMode sgReadyMode);

    bool setup(bool gpio1Enabled, bool gpio2Enabled);
    bool isValid() const;

    Gpio *gpio1() const;
    Gpio *gpio2() const;

signals:
    void sgReadyModeChanged(SgReadyMode sgReadyMode);

private:
    SgReadyMode m_sgReadyMode = SgReadyModeStandard;
    int m_gpioNumber1 = -1;
    int m_gpioNumber2 = -1;

    Gpio *m_gpio1 = nullptr;
    Gpio *m_gpio2 = nullptr;

    Gpio *setupGpio(int gpioNumber, bool initialValue);
};

#endif // SGREADYINTERFACE_H
