// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-plugins.
*
* nymea-plugins is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-plugins is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-plugins. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef KODIJSONHANDLER_H
#define KODIJSONHANDLER_H

#include <QObject>
#include <QVariant>
#include <QHash>

#include "kodiconnection.h"
#include "kodireply.h"

class KodiJsonHandler : public QObject
{
    Q_OBJECT
public:
    explicit KodiJsonHandler(KodiConnection *connection, QObject *parent = nullptr);

    int sendData(const QString &method, const QVariantMap &params);

signals:
    void notificationReceived(const QString &method, const QVariantMap &params);
    void replyReceived(int id, const QString &method, const QVariantMap &params);

private slots:
    void processResponse(const QByteArray &data);

private:
    KodiConnection *m_connection = nullptr;
    int m_id;
    QHash<int, KodiReply> m_replys;
    QByteArray m_dataBuffer;

};

#endif // KODIJSONHANDLER_H
