// SPDX-License-Identifier: LGPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* nymea-remoteproxy
* Tunnel proxy server for the nymea remote access
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-remoteproxy.
*
* nymea-remoteproxy is free software: you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* as published by the Free Software Foundation, either version 3
* of the License, or (at your option) any later version.
*
* nymea-remoteproxy is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with nymea-remoteproxy. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef WEBSOCKETSERVER_H
#define WEBSOCKETSERVER_H

#include <QUrl>
#include <QUuid>
#include <QObject>
#include <QWebSocket>
#include <QWebSocketServer>
#include <QSslConfiguration>

#include "transportinterface.h"

namespace remoteproxy {

class WebSocketServer : public TransportInterface
{
    Q_OBJECT
public:
    explicit WebSocketServer(bool sslEnabled, const QSslConfiguration &sslConfiguration, QObject *parent = nullptr);
    ~WebSocketServer() override;

    bool running() const override;

    QSslConfiguration sslConfiguration() const;

    void sendData(const QUuid &clientId, const QByteArray &data) override;
    void killClientConnection(const QUuid &clientId, const QString &killReason) override;

    uint connectionsCount() const override;

private:
    QWebSocketServer *m_server = nullptr;
    bool m_sslEnabled;
    QSslConfiguration m_sslConfiguration;

    QHash<QUuid, QWebSocket *> m_clientList;

private slots:
    void onClientConnected();
    void onClientDisconnected();
    void onTextMessageReceived(const QString &message);
    void onBinaryMessageReceived(const QByteArray &data);
    void onClientError(QAbstractSocket::SocketError error);
    void onAcceptError(QAbstractSocket::SocketError error);
    void onServerError(QWebSocketProtocol::CloseCode closeCode);

public slots:
    bool startServer() override;
    bool stopServer() override;

};

}

#endif // WEBSOCKETSERVER_H
