/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * Copyright (C) 2016-2024 chargebyte GmbH - All Rights Reserved
 *
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 *
 * Written by Simon Stürz <simon.stuerz@nymea.io>
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "dbusagent.h"
#include "loggingcategories.h"

DBusAgent::DBusAgent(QObject *parent) :
    QObject(parent),
    m_dbus(QDBusConnection::systemBus())
{
    m_adapter = new MenderAdaptor(this);
}

DBusAgent::~DBusAgent()
{

}

void DBusAgent::StateEntered(const QString &state)
{
    emit stateEntered(state);
}

void DBusAgent::StateLeave(const QString &state)
{
    emit stateLeave(state);
}

bool DBusAgent::connectToDBus(QDBusConnection::BusType busType)
{
    QString busName = QString::fromLatin1(IoGuhNymeadUpdateMenderInterface::staticInterfaceName());
    m_dbus = QDBusConnection::connectToBus(busType, busName);
    if (!m_dbus.registerService(busName)) {
        qCWarning(dcPlatformUpdate()) << "Failed to register D-Bus service" << busName;
        return false;
    }

    if (!m_dbus.registerObject("/io/guh/nymead/update/mender", this)) {
        qCWarning(dcPlatformUpdate()) << "Couldn't register agent at" << "/io/guh/nymead/update/mender";
        return false;
    }
    return true;
}
