/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * Copyright (C) 2016-2024 chargebyte GmbH - All Rights Reserved
 *
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 *
 * Written by Simon Stürz <simon.stuerz@nymea.io>
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef DBUSAGENT_H
#define DBUSAGENT_H

#include "mender_adaptor.h"
#include "mender_interface.h"

#include <QObject>
#include <QDBusConnection>

class DBusAgent : public QObject
{
    Q_OBJECT
public:
    explicit DBusAgent(QObject *parent = nullptr);
    ~DBusAgent();

private:
    QDBusConnection m_dbus;
    MenderAdaptor *m_adapter = nullptr;

signals:
    void stateEntered(const QString &stateString);
    void stateLeave(const QString &stateString);

private slots:
    void StateEntered(const QString &state);
    void StateLeave(const QString &state);

public slots:
    bool connectToDBus(QDBusConnection::BusType busType);

};

#endif // DBUSAGENT_H
