// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-update-plugin-mender-inro.
*
* nymea-update-plugin-mender-inro is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-update-plugin-mender-inro is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-update-plugin-mender-inro. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef DBUSAGENT_H
#define DBUSAGENT_H

#include "mender_adaptor.h"
#include "mender_interface.h"

#include <QObject>
#include <QDBusConnection>

class DBusAgent : public QObject
{
    Q_OBJECT
public:
    explicit DBusAgent(QObject *parent = nullptr);
    ~DBusAgent();

private:
    QDBusConnection m_dbus;
    MenderAdaptor *m_adapter = nullptr;

signals:
    void stateEntered(const QString &stateString);
    void stateLeave(const QString &stateString);

private slots:
    void StateEntered(const QString &state);
    void StateLeave(const QString &state);

public slots:
    bool connectToDBus(QDBusConnection::BusType busType);

};

#endif // DBUSAGENT_H
