
TEMPLATE = lib
TARGET = $$qtLibraryTarget(nymea_updatepluginmenderinro)

greaterThan(QT_MAJOR_VERSION, 5) {
    message("Building using Qt6 support")
    CONFIG *= c++17
    QMAKE_LFLAGS *= -std=c++17
    QMAKE_CXXFLAGS *= -std=c++17
} else {
    message("Building using Qt5 support")
    CONFIG *= c++11
    QMAKE_LFLAGS *= -std=c++11
    QMAKE_CXXFLAGS *= -std=c++11
    DEFINES += QT_DISABLE_DEPRECATED_UP_TO=0x050F00
}

QMAKE_CXXFLAGS *= -Werror -g

CONFIG += plugin link_pkgconfig
PKGCONFIG += nymea

QT -= gui
QT += dbus

SOURCES += \
    updatecontrollermender.cpp \
    dbus/dbusagent.cpp \
#    dbus/mender_adaptor.cpp \
#    dbus/mender_interface.cpp

HEADERS += \
    updatecontrollermender.h \
    dbus/dbusagent.h \
#    dbus/mender_adaptor.h \
#    dbus/mender_interface.h


DBUS_ADAPTORS += dbus/io.guh.nymead.update.mender.xml
DBUS_INTERFACES += dbus/io.guh.nymead.update.mender.xml

# Install translation files
TRANSLATIONS *= $$files($${_PRO_FILE_PWD_}/translations/*ts, true)
lupdate.depends = FORCE
lupdate.depends += qmake_all
lupdate.commands = lupdate -recursive -no-obsolete $${_PRO_FILE_PWD_}/nymea-update-plugin-mender-inro.pro
QMAKE_EXTRA_TARGETS += lupdate

# make lrelease to build .qm from .ts
lrelease.depends = FORCE
lrelease.commands += lrelease $$files($$_PRO_FILE_PWD_/translations/*.ts, true);
QMAKE_EXTRA_TARGETS += lrelease

translations.depends += lrelease
translations.path = /usr/share/nymea/translations
translations.files = $$_PRO_FILE_PWD_/translations/*.qm
message("trans files: $${translations.files}")
INSTALLS += translations

target.path = $$[QT_INSTALL_LIBS]/nymea/platform/
INSTALLS += target
