// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-update-plugin-mender.
*
* nymea-update-plugin-mender is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-update-plugin-mender is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-update-plugin-mender. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "dbusagent.h"
#include "loggingcategories.h"

DBusAgent::DBusAgent(QObject *parent) :
    QObject(parent),
    m_dbus(QDBusConnection::systemBus())
{
    m_adapter = new MenderAdaptor(this);
}

DBusAgent::~DBusAgent()
{

}

void DBusAgent::StateEntered(const QString &state)
{
    emit stateEntered(state);
}

void DBusAgent::StateLeave(const QString &state)
{
    emit stateLeave(state);
}

bool DBusAgent::connectToDBus(QDBusConnection::BusType busType)
{
    QString busName = QString::fromLatin1(IoGuhNymeadUpdateMenderInterface::staticInterfaceName());
    m_dbus = QDBusConnection::connectToBus(busType, busName);
    if (!m_dbus.registerService(busName)) {
        qCWarning(dcPlatformUpdate()) << "Failed to register D-Bus service" << busName;
        return false;
    }

    if (!m_dbus.registerObject("/io/guh/nymead/update/mender", this)) {
        qCWarning(dcPlatformUpdate()) << "Couldn't register agent at" << "/io/guh/nymead/update/mender";
        return false;
    }
    return true;
}
