// SPDX-License-Identifier: LGPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* nymea-zigbee
* Zigbee integration module for nymea
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-zigbee.
*
* nymea-zigbee is free software: you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* as published by the Free Software Foundation, either version 3
* of the License, or (at your option) any later version.
*
* nymea-zigbee is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with nymea-zigbee. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef ZIGBEECLUSTERATTRIBUTE_H
#define ZIGBEECLUSTERATTRIBUTE_H

#include <QDebug>

#include "zigbee.h"
#include "zigbeedatatype.h"

class ZigbeeClusterAttribute
{
public:
    ZigbeeClusterAttribute();
    ZigbeeClusterAttribute(quint16 id, const ZigbeeDataType &dataType);
    ZigbeeClusterAttribute(const ZigbeeClusterAttribute &other);

    quint16 id() const;
    ZigbeeDataType dataType() const;

    ZigbeeClusterAttribute &operator=(const ZigbeeClusterAttribute &other);
    bool operator==(const ZigbeeClusterAttribute &other) const;
    bool operator!=(const ZigbeeClusterAttribute &other) const;

    bool isValid() const;

private:
    quint16 m_id = 0xffff;
    ZigbeeDataType m_dataType;
};

QDebug operator<<(QDebug debug, const ZigbeeClusterAttribute &attribute);


#endif // ZIGBEECLUSTERATTRIBUTE_H
