#  Copyright (C) 2019 Michael Zanetti <michael.zanetti@nymea.io>
#  Copyright (C) 2018 Simon Stürz <simon.stuerz@nymea.io>
#
#  This file is part of nymea.
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License, or (at your option) any later version.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; If not, see
#  <http://www.gnu.org/licenses/>.

# This project include file is meant to be used by nymea plugins.

# Example project file for a plugin:

# include($$[QT_INSTALL_PREFIX]/include/nymea/plugi.pri)
# SOURCES += integrationpluginexample.cpp
# HEADERS += integrationpluginexample.h


TEMPLATE = lib
CONFIG += plugin link_pkgconfig

PKGCONFIG += nymea

greaterThan(QT_MAJOR_VERSION, 5) {
    message("Building using Qt6 support")
    CONFIG *= c++17
    QMAKE_LFLAGS *= -std=c++17
    QMAKE_CXXFLAGS *= -std=c++17
} else {
    message("Building using Qt5 support")
    CONFIG *= c++11
    QMAKE_LFLAGS *= -std=c++11
    QMAKE_CXXFLAGS *= -std=c++11
    DEFINES += QT_DISABLE_DEPRECATED_UP_TO=0x050F00
}

QMAKE_CXXFLAGS *= -Werror -g -Wno-deprecated-declarations
QMAKE_LFLAGS *= -z defs

JSONFILE=$${_PRO_FILE_PWD_}/integrationplugin"$$TARGET".json

# Make the device plugin json file visible in the Qt Creator
OTHER_FILES += $$JSONFILE

# Compile the plugininfo.h file
plugininfo.input = JSONFILE
plugininfo.output = plugininfo.h
plugininfo.commands = nymea-plugininfocompiler ${QMAKE_FILE_NAME} --output ${QMAKE_FILE_OUT}
plugininfo.dependency_type = TYPE_C
plugininfo.CONFIG += no_link combine
QMAKE_EXTRA_COMPILERS += plugininfo

# Compile the extern-plugininfo.h file
extern_plugininfo.input = JSONFILE
extern_plugininfo.output = extern-plugininfo.h
extern_plugininfo.commands = nymea-plugininfocompiler ${QMAKE_FILE_NAME} --extern ${QMAKE_FILE_OUT}
extern_plugininfo.dependency_type = TYPE_C
extern_plugininfo.CONFIG += no_link combine
QMAKE_EXTRA_COMPILERS += extern_plugininfo

# Clean up autogenerated plugin info files
plugininfo_clean.commands = rm -fv $$OUT_PWD/plugininfo.h $$OUT_PWD/extern-plugininfo.h
clean.depends = plugininfo_clean
QMAKE_EXTRA_TARGETS += clean plugininfo_clean

# Make sure the plugininfo.h is found in HEADERS for extracting translations
HEADERS += $$OUT_PWD/plugininfo.h

# Install translation files
TRANSLATIONS *= $$files($${_PRO_FILE_PWD_}/translations/*ts, true)
lupdate.depends = FORCE
lupdate.depends += qmake_all
lupdate.commands = nymea-plugininfocompiler $${JSONFILE} --translations $${_PRO_FILE_PWD_}/translations/; \
                   lupdate -recursive -no-obsolete $${_PRO_FILE_PWD_}/"$$TARGET".pro;
QMAKE_EXTRA_TARGETS += lupdate

# make lrelease to build .qm from .ts
lrelease.depends = FORCE
lrelease.commands += lrelease $$files($$_PRO_FILE_PWD_/translations/*.ts, true);
lrelease.commands += rsync -a $${_PRO_FILE_PWD_}/translations/*.qm $${OUT_PWD}/translations/;
QMAKE_EXTRA_TARGETS += lrelease

translations.path = /usr/share/nymea/translations
translations.files = $$[QT_SOURCE_TREE]/translations/*.qm

# Redefine target to make output file suite the plugin filename schema
TARGET = $$qtLibraryTarget(nymea_integrationplugin"$$TARGET")

target.depends += $${JSONFILE}

# Install plugin
target.path = $$[QT_INSTALL_LIBS]/nymea/plugins/
INSTALLS += target translations
